function h_fig = plot_error(id_fig,V_LF,V_LWLS,V_NWLS)

h_fig = figure (id_fig);
clf;

%% Linear Estimator

subplot(2,2,1);

e = real(V_LWLS)-real(V_LF);
e = e(:);

[e_center,f_actual,f_fitted] = get_distribution(e(:),100);

hold on;
bar(e_center,f_actual,'FaceColor','c','EdgeColor','none');
plot(e_center,f_fitted,'--b');
hold off;

grid on;

title('LWLS Estimator');
xlabel('Errow w.r.t. Real Part (p.u.)');
ylabel('Probability Density');
legend({'Actual Distribution','Fitted Normal Distribution'});

subplot(2,2,3);

e = imag(V_LWLS)-imag(V_LF);
e = e(:);

[e_center,f_actual,f_fitted] = get_distribution(e(:),100);

hold on;
bar(e_center,f_actual,'FaceColor','c','EdgeColor','none');
plot(e_center,f_fitted,'--b');
hold off;

grid on;

xlabel('Error w.r.t. Imaginary Part (p.u.)');
ylabel('Probability Density');
legend({'Actual Distribution','Fitted Normal Distribution'});

%% Nonlinear Estimator

subplot(2,2,2);

e = abs(V_NWLS)-abs(V_LF);
e = e(:);

[e_center,f_actual,f_fitted] = get_distribution(e(:),100);

hold on;
bar(e_center,f_actual,'FaceColor','c','EdgeColor','none');
plot(e_center,f_fitted,'--b');
hold off;

grid on;

title('NWLS Estimator');
xlabel('Error w.r.t. Magnitude (p.u.)');
ylabel('Probability Density');
legend({'Actual Distribution','Fitted Normal Distribution'});

subplot(2,2,4);

e = angle(V_NWLS)-angle(V_LF);
e = e(:);

[e_center,f_actual,f_fitted] = get_distribution(e(:),100);

hold on;
bar(e_center,f_actual,'FaceColor','c','EdgeColor','none');
plot(e_center,f_fitted,'--b');
hold off;

grid on;

xlabel('Error w.r.t. Angle (rad)');
ylabel('Probability Density');
legend({'Actual Distribution','Fitted Normal Distribution'});

%% Beautification

set(gca,'LooseInset',get(gca,'TightInset'));

end